package com.hero.ui;

import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;

import javax.swing.JFrame;

import com.hero.HeroDesigner;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class AbilityFrame extends JFrame {

	private static final long serialVersionUID = -618555923403972580L;

	public AbilityFrame(String title, Container content) {
		super(title);
		setIconImage(Toolkit.getDefaultToolkit().createImage(
				ClassLoader.getSystemResource("icon.jpg")));
		setContentPane(content);
		addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(WindowEvent e) {
				HeroDesigner.getInstance().mainPanel.states.put(
						getContentPane(), "0");
				HeroDesigner.getInstance().mainPanel.reset();
			}
		});
		addWindowFocusListener(new WindowFocusListener() {
			public void windowGainedFocus(WindowEvent e) {
				if (isShowing()) {
					HeroDesigner.getInstance().mainPanel
							.tabChanged(getContentPane());
				}
			}

			public void windowLostFocus(WindowEvent e) {
			}
		});
	}

	@Override
	public void setVisible(boolean val) {
		if (val) {
			super.setVisible(true);
			if (HeroDesigner.getInstance().getPrefs().getTearOffPrefs().get(
					getTitle()) != null) {
				Integer[] vals = HeroDesigner.getInstance().getPrefs()
						.getTearOffPrefs().get(getTitle());
				setSize(vals[0].intValue(), vals[1].intValue());
				this.setLocation(vals[2].intValue(), vals[3].intValue());
				validate();
			}
		} else {
			Integer[] vals = new Integer[5];
			vals[0] = new Integer(getWidth());
			vals[1] = new Integer(getHeight());
			vals[2] = new Integer((int) getLocation().getX());
			vals[3] = new Integer((int) getLocation().getY());
			vals[4] = new Integer(0);
			HeroDesigner.getInstance().getPrefs().getTearOffPrefs().put(
					getTitle(), vals);
			super.setVisible(false);
		}
	}
}
